/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp.data;

import com.ibm.hsc.auiml.databeans.sfp.data.CSPError;
import com.ibm.hsc.auiml.databeans.sfp.data.StructuredData;
import com.ibm.hsc.websm.sfp.SelectServiceableEvent;
import com.ibm.rsct.util.CtStructuredData;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

public class ManagedObject
extends StructuredData
implements Serializable {
    private static final int ERROR_CLASS = 0;
    private static final int CEC_MT = 1;
    private static final int CEC_MS = 2;
    private static final int DEV_MT = 3;
    private static final int DEV_MS = 4;
    private static final int ERROR_CODE = 5;
    private static final int ERROR_TEXT = 6;
    private static final int REPORTING_LOC_CODE = 7;
    private static final int PARTITION_ID = 8;
    private static final int PARTITION_NAME = 9;
    private static final int HOST_NAME = 10;
    private static final int OS_TYPE = 11;
    private static final int ORIG_TIMESTAMP = 12;
    private static final int LAST_TIMESTAMP = 13;
    private static final int ERR_LOG_RESOURCE = 14;
    private static final int ERR_LOG_SEQ_NUM = 15;
    private static final int DUPLICATE_COUNT = 16;
    private static final int PTR_LOCAL_EED_1 = 17;
    private static final int PTR_LOCAL_EED_2 = 18;
    private static final int CSP_TIMESTAMPS = 20;
    private static final int CSP_ERROR_CODES = 21;
    private static final int CSP_ERROR_TEXTS = 22;
    private static final int CSP_LOC_CODES = 23;
    private static final int CSP_INT_FRU_IDS = 24;
    private static final int CSP_PRIORITIES = 25;
    private static final int CSP_LOG_DETAILS = 26;
    private static final int CSP_OP_PANEL = 27;
    private static final int HMC_NLS_LOCALES = 28;
    private static final int HMC_NLS_ERROR_TEXTS = 29;
    private static final int ADDITIONAL_DATA_ARRAY = 30;
    private static final int CLUSTER_MTMS = 31;
    private static final int FNM_NETWORK_ID = 32;
    private static final int CREATED_TIMESTAMP = 33;
    String machineName = null;
    CSPError[] cspErrors = null;
    private Locale locale = null;

    public ManagedObject(CtStructuredData ctStructuredData, Locale locale) {
        super(ctStructuredData);
        this.locale = locale;
        this.machineName = SelectServiceableEvent.getMachineName(this);
    }

    public String getMachineName() {
        return this.machineName;
    }

    public String getErrorClass() {
        return this.getStringMember(0);
    }

    public String[] getCecMT() {
        return this.getStringArrayMember(1);
    }

    public String[] getCecMS() {
        return this.getStringArrayMember(2);
    }

    public String getDevMT() {
        return this.getStringMember(3);
    }

    public String getDevMS() {
        return this.getStringMember(4);
    }

    public String getClusterMT() {
        String[] stringArray = this.getStringArrayMember(31);
        return stringArray != null && stringArray.length > 0 ? stringArray[0] : "";
    }

    public String getClusterMS() {
        String[] stringArray = this.getStringArrayMember(31);
        return stringArray != null && stringArray.length > 1 ? stringArray[1] : "";
    }

    public String getDevMTMS() {
        return this.getDevMT() + "/" + this.getDevMS();
    }

    public String getErrorCode() {
        return this.getStringMember(5);
    }

    public String getErrorText() {
        return this.getErrorText(this.locale);
    }

    public String getErrorText(Locale locale) {
        String string = this.getLocaleErrorText(locale);
        return string == null ? this.getDefaultErrorText() : string;
    }

    private String getLocaleErrorText(Locale locale) {
        return this.getLocaleErrorText(locale.toString());
    }

    private String getLocaleErrorText(String string) {
        String[] stringArray = this.getNLSLocales();
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                String[] stringArray2 = this.getNLSErrorTexts();
                if (n >= stringArray2.length) break;
                string2 = stringArray2[n];
                break;
            }
            ++n;
        }
        return string2;
    }

    public String getDefaultErrorText() {
        String string = this.getLocaleErrorText("en_US");
        return string == null ? this.getStringMember(6) : string;
    }

    public String getReportingLocCode() {
        return this.getStringMember(7);
    }

    public String getPartitionId() {
        return this.getStringMember(8);
    }

    public String getPartitionName() {
        return this.getStringMember(9);
    }

    public String getHostName() {
        return this.getStringMember(10);
    }

    public String getOSType() {
        return this.getStringMember(11);
    }

    public Date getOrigTimestampDate() {
        return this.getTimestampMember(12);
    }

    public String getOrigTimestamp() {
        return this.getStringMember(12);
    }

    public Date getLastTimestampDate() {
        return this.getTimestampMember(13);
    }

    public String getLastTimestamp() {
        return this.getStringMember(13);
    }

    public String getErrLogResource() {
        return this.getStringMember(14);
    }

    public int getErrLogSeqNum() {
        return this.getIntegerMember(15);
    }

    public int getDuplicateCount() {
        return this.getIntegerMember(16);
    }

    public String getPtrLocalEED1() {
        return this.getStringMember(17);
    }

    public String getPtrLocalEED2() {
        return this.getStringMember(18);
    }

    public String getAdditionalData() {
        String[] stringArray = this.getStringArrayMember(30);
        return stringArray != null && stringArray.length > 4 ? stringArray[4] : "";
    }

    public synchronized CSPError[] getCSPErrors() {
        if (this.cspErrors == null) {
            this.parseCSPErrors();
        }
        return this.cspErrors;
    }

    private void parseCSPErrors() {
        String[] stringArray = this.getStringArrayMember(20);
        String[] stringArray2 = this.getStringArrayMember(21);
        String[] stringArray3 = this.getStringArrayMember(22);
        String[] stringArray4 = this.getStringArrayMember(23);
        String[] stringArray5 = this.getStringArrayMember(24);
        String[] stringArray6 = this.getStringArrayMember(25);
        String[] stringArray7 = this.getStringArrayMember(26);
        String[] stringArray8 = this.getStringArrayMember(27);
        int n = Math.max(stringArray.length, stringArray2.length);
        n = Math.max(n, stringArray3.length);
        n = Math.max(n, stringArray4.length);
        n = Math.max(n, stringArray5.length);
        n = Math.max(n, stringArray6.length);
        n = Math.max(n, stringArray7.length);
        n = Math.max(n, stringArray8.length);
        this.cspErrors = new CSPError[n];
        int n2 = 0;
        while (n2 < n) {
            String string = n2 < stringArray.length ? stringArray[n2] : "";
            String string2 = n2 < stringArray2.length ? stringArray2[n2] : "";
            String string3 = n2 < stringArray3.length ? stringArray3[n2] : "";
            String string4 = n2 < stringArray4.length ? stringArray4[n2] : "";
            String string5 = n2 < stringArray5.length ? stringArray5[n2] : "";
            String string6 = n2 < stringArray6.length ? stringArray6[n2] : "";
            String string7 = n2 < stringArray7.length ? stringArray7[n2] : "";
            String string8 = n2 < stringArray8.length ? stringArray8[n2] : "";
            this.cspErrors[n2] = new CSPError(string, string2, string3, string4, string5, string6, string7, string8);
            ++n2;
        }
    }

    public String[] getNLSLocales() {
        return this.getStringArrayMember(28);
    }

    public String[] getNLSErrorTexts() {
        return this.getStringArrayMember(29);
    }

    public String getFNMNetworkID() {
        return this.getStringMember(32);
    }

    public String getCreatedTimestamp() {
        return this.getStringMember(33);
    }

    public Date getCreatedTimestampDate() {
        return this.getTimestampMember(33);
    }
}

